// File: CEG_ControlClasses.hpp
// Version: 1.1
// Author: Loyalguard
// Description: Define based controls for all CEG dialogs.  Included from CEG_Dialogs.hpp.

// CONTROL CLASSES

// CEG Base Control Classes

class CEG_StaticText
{
   // COMMON
    idc = -1;
    moving  =  false;
    type = CT_STATIC;
    style = ST_CENTER; // ST_LEFT
    font = FontM;
    sizeEx = 0.025;
 
    x = 0.00;
    y = 0.00;
    w = 0.00; 
    h = 0.00;
    
    // CT_STATIC
    //lineSpacing = 0.00; // Only Req. for ST_MULTI/
    colorText[] = CEG_COLOR_BLACK;
    colorBackground[] = CEG_COLOR_WHITE;
    text = "";
};

class CEG_StaticFrame
{
   // COMMON
    idc = -1;
    moving  =  false;
	type = CT_STATIC;
	style = ST_FRAME;
    font = FontM;
    sizeEx = 0.025;
 
    x = 0.00;
    y = 0.00;
    w = 0.00; 
    h = 0.00;
    
    //CT_STATIC
    colorText[] = CEG_COLOR_WHITE;
    colorBackground[] = CEG_COLOR_DKGRAY;
    text = "";
};

class CEG_StaticRect
{
   // COMMON
    idc = -1;
    moving  =  false;
    type = CT_STATIC;
    style = ST_CENTER; // ST_LEFT
    font = FontM;
    sizeEx = 0.025;
 
    x = 0.00;
    y = 0.00;
    w = 0.00; 
    h = 0.00;
    
    // CT_STATIC
    colorText[] = CEG_COLOR_CLEAR;
    colorBackground[] = CEG_COLOR_CLEAR;
    text = "";
};

class CEG_StaticPicture
{
    // COMMON
    idc = -1;
    moving  =  false;
    type = CT_STATIC;
    style = ST_PICTURE;
    font = FontM;
    sizeEx = 0.025;
 
    x = 0.00;
    y = 0.00;
    w = 0.00; 
    h = 0.00;
 
    // CT_STATIC
    colorText[] = {};
    colorBackground[] = {};
    text = ""; // path\filename.paa
};

class CEG_StructText
{
	// COMMON
	idc = -1;
    moving  =  false;
	type = CT_STRUCTURED_TEXT;
    style = ST_LEFT; //  ST_CENTER
    //font = FontM;
    //sizeEx = 0.025;
  
    x = 0.1; 
	y = 0.1; 
	w = 0.3; 
	h = 0.1; 
  
  // CT_STRUCTURED_TEXT
  colorBackground[] = CEG_COLOR_WHITE; 
  colorText[] = CEG_COLOR_BLACK;
  size = 0.025;
  text = "";
  class Attributes 
		{
			font = FontM;
			color = "#000000";
			align = "left";
			valign = "top";
			shadow = false;
			shadowColor = "#ff0000";
			size = "1";
		};
};

class CEG_Button
{
	// COMMON
	idc = -1;
	moving  =  false;
	type = CT_BUTTON;
	style = ST_CENTER; //ST_LEFT
	font = FontM;
	sizeEx = 0.03;
	
	x = 0.0;
	y = 0.0;
	w = 0.0;
	h = 0.0;
		
	// CT_Button
	colorText[] = CEG_COLOR_BLACK;
	colorFocused[] = CEG_COLOR_WHITE;   // border color for focused state
	colorDisabled[] = { 0, 0, 1, 0.7 }; // Blue/30% Transparent  // text color for disabled state
	colorBackground[] = CEG_COLOR_LTGRAY;
	colorBackgroundDisabled[] = CEG_COLOR_LTGRAY;  // background color for disabled state
	colorBackgroundActive[] = CEG_COLOR_WHITE;   // background color for active state
	offsetX = 0.003;
	offsetY = 0.003;
	offsetPressedX = 0.002;
	offsetPressedY = 0.002;
	colorShadow[] = { 0, 0, 0, 0.5 };
	colorBorder[] = { 0, 0, 0, 1 };
	borderSize = 0;
	soundEnter[] = { "", 0, 1 };  // no sound
	soundPush[] = { "buttonpushed.ogg", 0.1, 1 };
	soundClick[] = { "", 0, 1 };  // no sound
	soundEscape[] = { "", 0, 1 };  // no sound
	text = "";
	action = "";
	default = false;
};

class CEG_ActiveText
{
	// COMMON
	idc = -1;
	moving  =  false;
	type = CT_ACTIVETEXT;
	style = ST_CENTER; //ST_LEFT
	font = FontM;
	sizeEx = 0.025;

	x = 0.00;
	y = 0.00;
	w = 0.00; 
	h = 0.00;

	// CT_ACTIVETEXT
	color[] = CEG_COLOR_WHITE;
	colorActive[] = { 1, 0.2, 0.2, 1 };
	soundEnter[] = { "", 0, 1 }; 
	soundPush[] = { "", 0, 1 };
	soundClick[] = { "", 0, 1 };
	soundEscape[] = { "", 0, 1 };
	action = "";
	text = "";
	default = false;
};

class CEG_EditText
{
	 // COMMON
	idc = -1;
	moving  =  false;
	type = CT_EDIT;
	style = ST_LEFT;
	font = FontM;
	sizeEx = 0.025;
	
	x = 0.00;
	y = 0.00;
	w = 0.00; 
	h = 0.00;
	
	//CT_EDIT
	autocomplete = false;
	colorSelection[] = CEG_COLOR_DKGRAY;
	colorText[] = CEG_COLOR_BLACK;
    colorBackground[] = CEG_COLOR_WHITE;
    text = "";
};

//CEG Sub Classes

class CEG_Frame: CEG_StaticFrame
{
    colorBackground[] = CEG_COLOR_CLEAR;
};

class CEG_H_Line: CEG_StaticRect
{
	h = (safeZoneH * 0.001); 
	colorBackground[] = CEG_COLOR_CYAN;
};

class CEG_V_Line: CEG_StaticRect
{
	w = (safeZoneW * 0.001); 
	colorBackground[] = CEG_COLOR_CYAN;
};

class CEG_Window: CEG_StaticText
{
    colorText[] = CEG_COLOR_BLACK;
    colorBackground[] = CEG_COLOR_LTGRAY;
};

class CEG_Rect: CEG_StaticRect
{
    colorBackground[] = CEG_COLOR_BLACK;
};

class CEG_Active: CEG_ActiveText
{
	color[] = CEG_COLOR_WHITE;
	colorActive[] = CEG_COLOR_YELLOW;
};
	
class CEG_Poles : CEG_StaticPicture
{
    style = ST_PICTURE + ST_KEEP_ASPECT_RATIO;
    text = "CEG\Textures\Poles.paa";
};